#include <Wire.h>
#include <VL53L1X.h> //polulu library

VL53L1X sensor;

#define SCL_PIN 0  // IO0 for SCL, top left of custom board
#define SDA_PIN 1  // IO1 for SDA, 1 under top left of custom board
// 3.3v pin is the top right pin
// gnd pin is the bottom right pin
// as seen by a person with the usbc port facing them
void setup() {
    Serial.begin(115200);
    Wire.begin(SDA_PIN, SCL_PIN);

    if (!sensor.init()) {
        Serial.println("Failed to detect VL53L1CX sensor!");
        while (1);
    }

    sensor.setTimeout(500);
    sensor.startContinuous(50);
}

void loop() {
    if (sensor.dataReady()) {
        sensor.read();
        int distance = sensor.ranging_data.range_mm;
        Serial.println(distance);  // Send distance to Processing
    }
    delay(50);
}
